<?php
defined("ABSPATH") or die("");
if (!defined('DUPLICATOR_PRO_VERSION')) exit; // Exit if accessed directly

require_once (DUPLICATOR_PRO_PLUGIN_PATH.'/classes/entities/class.system.global.entity.php');
require_once (DUPLICATOR_PRO_PLUGIN_PATH.'/classes/utilities/class.u.shell.php');
require_once (DUPLICATOR_PRO_PLUGIN_PATH.'/classes/class.archive.config.php');
require_once (DUPLICATOR_PRO_PLUGIN_PATH.'/classes/entities/class.brand.entity.php');
require_once (DUPLICATOR_PRO_PLUGIN_PATH.'/classes/class.password.php');

class DUP_PRO_Installer
{
    public $File;
    public $Size = 0;
    //SETUP
    public $OptsSecureOn;
    public $OptsSecurePass;
    public $OptsSkipScan;
    //BASIC
    public $OptsDBHost;
    public $OptsDBName;
    public $OptsDBUser;
    //CPANEL
    public $OptsCPNLHost     = '';
    public $OptsCPNLUser     = '';
    public $OptsCPNLPass     = '';
    public $OptsCPNLEnable   = false;
    public $OptsCPNLConnect  = false;
    //CPANEL DB
    //1 = Create New, 2 = Connect Remove
    public $OptsCPNLDBAction = 'create';
    public $OptsCPNLDBHost   = '';
    public $OptsCPNLDBName   = '';
    public $OptsCPNLDBUser   = '';
    //PROTECTED
    protected $Package;

    public $numFilesAdded = 0;
    public $numDirsAdded = 0;

    //CONSTRUCTOR
    function __construct($package)
    {
        $this->Package = $package;
    }

    public function get_safe_filepath()
    {
        return DUP_PRO_U::safePath(DUPLICATOR_PRO_SSDIR_PATH."/{$this->File}");
    }

    public function get_url()
    {
        return DUPLICATOR_PRO_SSDIR_URL."/{$this->File}";
    }

    public function build($package, $build_progress)
    {
        /* @var $package DUP_PRO_Package */
        DUP_PRO_LOG::trace("building installer");

        $this->Package = $package;
        $success       = false;

        if ($this->create_enhanced_installer_files()) {
            $success = $this->add_extra_files($package);
        }

        if ($success) {
            $build_progress->installer_built = true;
        } else {
            $build_progress->failed = true;
        }
    }

    private function create_enhanced_installer_files()
    {
        $success = false;

        if ($this->create_enhanced_installer()) {
            $success = $this->create_archive_config_file();
        }

        return $success;
    }

    private function create_enhanced_installer()
    {
        $global = DUP_PRO_Global_Entity::get_instance();

        $success = true;

		$archive_filepath        = DUP_PRO_U::safePath("{$this->Package->StorePath}/{$this->Package->Archive->File}");
        $installer_filepath     = DUP_PRO_U::safePath(DUPLICATOR_PRO_SSDIR_PATH_TMP)."/{$this->Package->NameHash}_{$global->installer_base_name}";
        $template_filepath      = DUPLICATOR_PRO_PLUGIN_PATH.'/installer/installer.tpl';
        // $csrf_class_filepath    = DUPLICATOR_PRO_PLUGIN_PATH.'/installer/dup-installer/classes/class.csrf.php';
        $mini_expander_filepath = DUPLICATOR_PRO_PLUGIN_PATH.'/lib/dup_archive/classes/class.duparchive.mini.expander.php';

        // Replace the @@ARCHIVE@@ token
        $installer_contents = file_get_contents($template_filepath);
        // $csrf_class_contents = file_get_contents($csrf_class_filepath);

        if ($this->Package->build_progress->current_build_mode == DUP_PRO_Archive_Build_Mode::DupArchive) {
            $mini_expander_string = file_get_contents($mini_expander_filepath);

            if ($mini_expander_string === false) {
                DUP_PRO_Log::error(DUP_PRO_U::__('Error reading DupArchive mini expander'), DUP_PRO_U::__('Error reading DupArchive mini expander'), false);
                return false;
            }
        } else {
            $mini_expander_string = '';
        }

        $search_array  = array('@@ARCHIVE@@', '@@VERSION@@', '@@ARCHIVE_SIZE@@', '@@PACKAGE_HASH@@', '@@CSRF_CRYPT@@', '@@DUPARCHIVE_MINI_EXPANDER@@');
        $package_hash = $this->Package->get_package_hash();
        $replace_array = array($this->Package->Archive->File, DUPLICATOR_PRO_VERSION, @filesize($archive_filepath), $package_hash, DUPLICATOR_PRO_INSTALLER_CSRF_CRYPT, $mini_expander_string);

        $installer_contents = str_replace($search_array, $replace_array, $installer_contents);

        if (@file_put_contents($installer_filepath, $installer_contents) === false) {
            DUP_PRO_Log::error(DUP_PRO_U::__('Error writing installer contents'), DUP_PRO_U::__("Couldn't write to $installer_filepath"), false);
            $success = false;
        }

        if ($success) {
            $storePath  = "{$this->Package->StorePath}/{$this->File}";
            $this->Size = @filesize($storePath);
        }

        return $success;
    }

    /* Create archive.txt file */
    private function create_archive_config_file()
    {
        global $wpdb;

        $global                  = DUP_PRO_Global_Entity::get_instance();
        $success                 = true;
        $archive_config_filepath = DUP_PRO_U::safePath(DUPLICATOR_PRO_SSDIR_PATH_TMP)."/{$this->Package->NameHash}_archive.txt";
        $ac                      = new DUP_PRO_Archive_Config();
        $extension               = strtolower($this->Package->Archive->Format);
		$hasher					 = new DUP_PRO_PasswordHash(8, FALSE);
		$pass_hash				 = $hasher->HashPassword($this->Package->Installer->OptsSecurePass);

        //READ-ONLY: COMPARE VALUES
        $ac->created     = $this->Package->Created;
        $ac->version_dup = DUPLICATOR_PRO_VERSION;
        $ac->version_wp  = $this->Package->VersionWP;
        $ac->version_db  = $this->Package->VersionDB;
        $ac->version_php = $this->Package->VersionPHP;
        $ac->version_os  = $this->Package->VersionOS;
        $ac->dbInfo      = $this->Package->Database->info;

        //READ-ONLY: GENERAL
        $ac->installer_base_name  = $global->installer_base_name;
        $ac->package_name         = "{$this->Package->NameHash}_archive.{$extension}";
        $ac->package_hash         = $this->Package->get_package_hash();

        $ac->package_notes        = $this->Package->Notes;
        $ac->url_old              = get_option('siteurl');
        $ac->opts_delete          = DUP_PRO_JSON_U::encode($GLOBALS['DUPLICATOR_PRO_OPTS_DELETE']);
        $ac->blogname             = sanitize_text_field(get_option('blogname'));
        $ac->wproot               = DUPLICATOR_PRO_WPROOTPATH;
        $ac->relative_content_dir = str_replace(ABSPATH, '', WP_CONTENT_DIR);
        $ac->relative_plugins_dir = str_replace(ABSPATH, '', WP_PLUGIN_DIR);
        $ac->relative_plugins_dir = str_replace($ac->wproot,'',$ac->relative_plugins_dir);
        $ac->relative_theme_dirs  = get_theme_roots();
        if(is_array($ac->relative_theme_dirs)){
            foreach ($ac->relative_theme_dirs as $key=>$dir){
                if(strpos($dir,$ac->wproot) === false){
                    $ac->relative_theme_dirs[$key] = $ac->relative_content_dir.$dir;
                }else{
                    $ac->relative_theme_dirs[$key] = str_replace($ac->wproot,'',$dir);
                }
            }
        }else{
            $ac->relative_theme_dirs = array();
            $dir = get_theme_roots();
            if(strpos($dir,$ac->wproot) === false){
                $ac->relative_theme_dirs[] = $ac->relative_content_dir.$dir;
            }else{
                $ac->relative_theme_dirs[] = str_replace($ac->wproot,'',$dir);
            }
        }
		$ac->exportOnlyDB		  = $this->Package->Archive->ExportOnlyDB;
		$ac->wplogin_url		  = wp_login_url();

        //PRE-FILLED: GENERAL
        $ac->secure_on   = $this->Package->Installer->OptsSecureOn;
        $ac->secure_pass = $pass_hash;
        $ac->skipscan    = $this->Package->Installer->OptsSkipScan;
        $ac->dbhost      = $this->Package->Installer->OptsDBHost;
        $ac->dbname      = $this->Package->Installer->OptsDBName;
        $ac->dbuser      = $this->Package->Installer->OptsDBUser;
        $ac->dbpass      = '';
        
        //PRE-FILLED: CPANEL
        $ac->cpnl_host     = $this->Package->Installer->OptsCPNLHost;
        $ac->cpnl_user     = $this->Package->Installer->OptsCPNLUser;
        $ac->cpnl_pass     = $this->Package->Installer->OptsCPNLPass;
        $ac->cpnl_enable   = $this->Package->Installer->OptsCPNLEnable;
        $ac->cpnl_connect  = $this->Package->Installer->OptsCPNLConnect;
        $ac->cpnl_dbaction = $this->Package->Installer->OptsCPNLDBAction;
        $ac->cpnl_dbhost   = $this->Package->Installer->OptsCPNLDBHost;
        $ac->cpnl_dbname   = $this->Package->Installer->OptsCPNLDBName;
        $ac->cpnl_dbuser   = $this->Package->Installer->OptsCPNLDBUser;

        //MULTISITE
        $ac->mu_mode = DUP_PRO_MU::getMode();
        $ac->wp_tableprefix = $wpdb->base_prefix;
        
        $ac->mu_generation = DUP_PRO_MU::getGeneration();
        $ac->mu_is_filtered = !empty($this->Package->Multisite->FilterSites) ? true : false;

        $ac->subsites = DUP_PRO_MU::getSubsites($this->Package->Multisite->FilterSites);
        if ($ac->subsites === false) {
            $success = false;
        }
        $ac->main_site_id = DUP_PRO_MU::get_main_site_id();

        //BRAND
        $ac->brand   = $this->the_brand_setup($this->Package->Brand_ID);

        //LICENSING
        $ac->license_limit = $global->license_limit;

        $ac->is_outer_root_wp_config_file = (!file_exists(DUPLICATOR_PRO_WPROOTPATH . 'wp-config.php')) ? true : false;
        $ac->is_outer_root_wp_content_dir = $this->Package->Archive->isOuterWPContentDir();
        if ($ac->is_outer_root_wp_content_dir && DUP_PRO_Archive_Build_Mode::Shell_Exec == $this->Package->build_progress->current_build_mode) {
            $wpContentDirNormalizePath = $this->Package->Archive->wpContentDirNormalizePath();
            $wpContentDirBase = basename($wpContentDirNormalizePath);
            if ('wp-content' == $wpContentDirBase) {
                $ac->wp_content_dir_base_name = '';
            } else {
                $ac->wp_content_dir_base_name = $wpContentDirBase;
            }
        } else {
            $ac->wp_content_dir_base_name = '';
        }

        $ac->csrf_crypt = DUPLICATOR_PRO_INSTALLER_CSRF_CRYPT;
        
        $json = DUP_PRO_JSON_U::encodePrettyPrint($ac);

        DUP_PRO_LOG::traceObject('json', $json);

        if (file_put_contents($archive_config_filepath, $json) === false) {
            DUP_PRO_Log::error("Error writing archive config", "Couldn't write archive config at $archive_config_filepath", false);
            $success = false;
        }

        return $success;
    }

    private function the_brand_setup($id)
    {
        // initialize brand
        $brand = DUP_PRO_Brand_Entity::get_by_id((int)$id);

        // Prepare default fields
        $brand_property_default = array(
            'logo' => '',
            'enabled' => false,
            'style' => array()
        );

        // Returns property
        $brand_property = array();

        // Set logo and hosted images path
        if(isset($brand->logo)){
            $brand_property['logo'] = $brand->logo;
            // Find images
            preg_match_all('/<img.*?src="([^"]+)".*?>/', $brand->logo, $arr_img, PREG_PATTERN_ORDER); // https://regex101.com/r/eEyf5S/2
            // Fix hosted image url path
            if( isset($arr_img[1]) && count($brand->attachments) > 0 && count($arr_img[1]) === count($brand->attachments) )
            {
                foreach($arr_img[1] as $i=>$find)
                {
                    $brand_property['logo'] = str_replace($find, 'assets/images/brand'.$brand->attachments[$i], $brand_property['logo']);
                }
            }
            $brand_property['logo'] = stripslashes($brand_property['logo']);
        }

        // Set is enabled
        if(!empty($brand_property['logo']) && isset($brand->active) && $brand->active)
            $brand_property['enabled'] = true;

        // Let's include style
        if(isset($brand->style)){
            $brand_property['style'] = $brand->style;
        }

        // Merge data properly
        if(function_exists("array_replace") && version_compare(phpversion(), '5.3.0', '>='))
			$brand_property = array_replace($brand_property_default, $brand_property); // (PHP 5 >= 5.3.0)
		else
			$brand_property = array_merge($brand_property_default, $brand_property); // (PHP 5 < 5.3.0)

        return $brand_property;
    }

    /**
     *  createZipBackup
     *  Puts an installer zip file in the archive for backup purposes.
     */
    private function add_extra_files($package)
    {
        $success                 = false;
        $global                  = DUP_PRO_Global_Entity::get_instance();
        $installer_filepath      = DUP_PRO_U::safePath(DUPLICATOR_PRO_SSDIR_PATH_TMP)."/{$this->Package->NameHash}_{$global->installer_base_name}";
        $scan_filepath           = DUP_PRO_U::safePath(DUPLICATOR_PRO_SSDIR_PATH_TMP)."/{$this->Package->NameHash}_scan.json";
        $file_list_filepath      = DUP_PRO_U::safePath(DUPLICATOR_PRO_SSDIR_PATH_TMP)."/{$this->Package->NameHash}_files.txt";
        $dir_list_filepath       = DUP_PRO_U::safePath(DUPLICATOR_PRO_SSDIR_PATH_TMP)."/{$this->Package->NameHash}_dirs.txt";
        $sql_filepath            = DUP_PRO_U::safePath("{$this->Package->StorePath}/{$this->Package->Database->File}");
        $archive_filepath        = DUP_PRO_U::safePath("{$this->Package->StorePath}/{$this->Package->Archive->File}");
        $archive_config_filepath = DUP_PRO_U::safePath(DUPLICATOR_PRO_SSDIR_PATH_TMP)."/{$this->Package->NameHash}_archive.txt";

        if (file_exists($installer_filepath) == false) {
            DUP_PRO_Log::error("Installer $installer_filepath not present", '', false);
            return false;
        }

        if (file_exists($sql_filepath) == false) {
            DUP_PRO_Log::error("Database SQL file $sql_filepath not present", '', false);
            return false;
        }

        if (file_exists($archive_config_filepath) == false) {
            DUP_PRO_Log::error("Archive configuration file $archive_config_filepath not present", '', false);
            return false;
        }

        if ($package->Archive->file_count != 2) {
            DUP_PRO_LOG::trace("Doing archive file check");
            // Only way it's 2 is if the root was part of the filter in which case the archive won't be there
            if (file_exists($archive_filepath) == false) {
                $error_text = sprintf(DUP_PRO_U::__("Zip archive %1$s not present."), $archive_filepath);
                //$fix_text   = DUP_PRO_U::__("Go to: Settings > Packages Tab > Set Archive Engine to ZipArchive.");
                $fix_text   = DUP_PRO_U::__("Click on button to set archive engine to DupArchive.");

                DUP_PRO_Log::error("$error_text. **RECOMMENDATION: $fix_text", '', false);

                $system_global = DUP_PRO_System_Global_Entity::get_instance();
                //$system_global->add_recommended_text_fix($error_text, $fix_text);
                $system_global->add_recommended_quick_fix($error_text, $fix_text, 'global : {archive_build_mode:3}');
                $system_global->save();

                return false;
            }
        }

        DUP_PRO_LOG::trace("Add extra files: Current build mode = ".$package->build_progress->current_build_mode);

        $wpconfig_filepath = $package->Archive->getWPConfigFilePath();
        if ($package->build_progress->current_build_mode == DUP_PRO_Archive_Build_Mode::ZipArchive) {
            $success = $this->add_extra_files_using_ziparchive($installer_filepath, $scan_filepath, $file_list_filepath, $dir_list_filepath, $sql_filepath, $archive_filepath, $archive_config_filepath, $wpconfig_filepath, $package->build_progress->current_build_compression);
        } else if ($package->build_progress->current_build_mode == DUP_PRO_Archive_Build_Mode::Shell_Exec) {
            $success = $this->add_extra_files_using_shellexec($archive_filepath, $installer_filepath, $scan_filepath, $file_list_filepath, $dir_list_filepath, $sql_filepath, $archive_config_filepath, $wpconfig_filepath, $package->build_progress->current_build_compression);
            // Adding the shellexec fail text fix
            if(!$success) {
                $error_text = DUP_PRO_U::__("Problem adding installer to archive");
                $fix_text   = DUP_PRO_U::__("Click on button to set archive engine to DupArchive.");
                
                $system_global = DUP_PRO_System_Global_Entity::get_instance();            
                $system_global->add_recommended_quick_fix($error_text, $fix_text, 'global : {archive_build_mode:3}');
                $system_global->save();
            }
        } else if ($package->build_progress->current_build_mode == DUP_PRO_Archive_Build_Mode::DupArchive) {
            $success = $this->add_extra_files_using_duparchive($installer_filepath, $scan_filepath, $file_list_filepath, $dir_list_filepath, $sql_filepath, $archive_filepath, $archive_config_filepath, $wpconfig_filepath);
        }

        // No sense keeping the archive config around
        @unlink($archive_config_filepath);

        $package->Archive->Size = @filesize($archive_filepath);

        return $success;
    }

    private function add_extra_files_using_duparchive($installer_filepath, $scan_filepath, $file_list_filepath, $dir_list_filepath, $sql_filepath, $archive_filepath, $archive_config_filepath, $wpconfig_filepath)
    {
        $success = false;

        try {
			$htaccess_filepath = DUPLICATOR_PRO_WPROOTPATH . '.htaccess';

            $logger = new DUP_PRO_Dup_Archive_Logger();

            DupArchiveEngine::init($logger, 'DUP_PRO_LOG::profile');

            $embedded_scan_ark_file_path = $this->getEmbeddedScanFilePath();
            DupArchiveEngine::addRelativeFileToArchiveST($archive_filepath, $scan_filepath, $embedded_scan_ark_file_path);
            $this->numFilesAdded++;

            $embedded_file_list_file_path = $this->getEmbeddedFileListFilePath();
            DupArchiveEngine::addRelativeFileToArchiveST($archive_filepath, $file_list_filepath, $embedded_file_list_file_path);
            $this->numFilesAdded++;

            $embedded_dir_list_file_path = $this->getEmbeddedDirListFilePath();
            DupArchiveEngine::addRelativeFileToArchiveST($archive_filepath, $dir_list_filepath, $embedded_dir_list_file_path);
            $this->numFilesAdded++;

			if(file_exists($htaccess_filepath)) {
				try
				{
					DupArchiveEngine::addRelativeFileToArchiveST($archive_filepath, $htaccess_filepath, DUPLICATOR_PRO_HTACCESS_ORIG_FILENAME);
					$this->numFilesAdded++;
				}
				catch (Exception $ex)
				{
					// Non critical so bury exception
				}
			}

			if(file_exists($wpconfig_filepath)) {
                $conf_ark_file_path = $this->getWPConfArkFilePath();
                $temp_conf_ark_file_path = $this->getTempWPConfArkFilePath();
                if (copy($wpconfig_filepath, $temp_conf_ark_file_path)) {
                    $this->cleanTempWPConfArkFilePath($temp_conf_ark_file_path);
                    DupArchiveEngine::addRelativeFileToArchiveST($archive_filepath, $temp_conf_ark_file_path, $conf_ark_file_path);
                    @unlink($temp_conf_ark_file_path);
                } else {
                    DupArchiveEngine::addRelativeFileToArchiveST($archive_filepath, $wpconfig_filepath, $conf_ark_file_path);
                }                
				$this->numFilesAdded++;
			}

            $this->add_installer_files_using_duparchive($archive_filepath, $installer_filepath, $archive_config_filepath);

            $success = true;
        } catch (Exception $ex) {
            DUP_PRO_Log::error("Error adding installer files to archive. ".$ex->getMessage());
        }

        return $success;
    }

    private function add_installer_files_using_duparchive($archive_filepath, $installer_filepath, $archive_config_filepath)
    {
        /* @var $global DUP_PRO_Global_Entity */
        $global                    = DUP_PRO_Global_Entity::get_instance();
        $installer_backup_filename = $global->get_installer_backup_filename();

		$installer_backup_filepath = dirname($installer_filepath) . "/{$installer_backup_filename}";

        DUP_PRO_LOG::trace('Adding enhanced installer files to archive using DupArchive');

		DupProSnapLibIOU::copy($installer_filepath, $installer_backup_filepath);

		DupArchiveEngine::addFileToArchiveUsingBaseDirST($archive_filepath, dirname($installer_backup_filepath), $installer_backup_filepath);

		DupProSnapLibIOU::rm($installer_backup_filepath);

        $this->numFilesAdded++;

        $base_installer_directory = DUPLICATOR_PRO_PLUGIN_PATH.'installer';
        $installer_directory      = "$base_installer_directory/dup-installer";

        $counts = DupArchiveEngine::addDirectoryToArchiveST($archive_filepath, $installer_directory, $base_installer_directory, true);
        $this->numFilesAdded += $counts->numFilesAdded;
        $this->numDirsAdded += $counts->numDirsAdded;

        $archive_config_relative_path = $this->getArchiveTxtFilePath();

        DupArchiveEngine::addRelativeFileToArchiveST($archive_filepath, $archive_config_filepath, $archive_config_relative_path);
        $this->numFilesAdded++;

        // Include dup archive
        $duparchive_lib_directory = DUPLICATOR_PRO_PLUGIN_PATH.'lib/dup_archive';
        $duparchive_lib_counts = DupArchiveEngine::addDirectoryToArchiveST($archive_filepath, $duparchive_lib_directory, DUPLICATOR_PRO_PLUGIN_PATH, true, 'dup-installer/');
        $this->numFilesAdded += $duparchive_lib_counts->numFilesAdded;
        $this->numDirsAdded += $duparchive_lib_counts->numDirsAdded;

        // Include config tranformer classes
        $config_lib_directory = DUPLICATOR_PRO_PLUGIN_PATH.'lib/config';
        $config_lib_counts = DupArchiveEngine::addDirectoryToArchiveST($archive_filepath, $config_lib_directory, DUPLICATOR_PRO_PLUGIN_PATH, true, 'dup-installer/');
        $this->numFilesAdded += $config_lib_counts->numFilesAdded;
        $this->numDirsAdded += $config_lib_counts->numDirsAdded;

        // Include snaplib
        $snaplib_directory = DUPLICATOR_PRO_PLUGIN_PATH.'lib/snaplib';
        $snaplib_counts = DupArchiveEngine::addDirectoryToArchiveST($archive_filepath, $snaplib_directory, DUPLICATOR_PRO_PLUGIN_PATH, true, 'dup-installer/');
        $this->numFilesAdded += $snaplib_counts->numFilesAdded;
        $this->numDirsAdded += $snaplib_counts->numDirsAdded;

        // Include fileops
        $fileops_directory = DUPLICATOR_PRO_PLUGIN_PATH.'lib/fileops';
        $fileops_counts = DupArchiveEngine::addDirectoryToArchiveST($archive_filepath, $fileops_directory, DUPLICATOR_PRO_PLUGIN_PATH, true, 'dup-installer/');
        $this->numFilesAdded += $fileops_counts->numFilesAdded;
        $this->numDirsAdded += $fileops_counts->numDirsAdded;
    }

    private function add_extra_files_using_ziparchive($installer_filepath, $scan_filepath, $file_list_filepath, $dir_list_filepath, $sql_filepath, $zip_filepath, $archive_config_filepath, $wpconfig_filepath, $is_compressed)
    {
		$htaccess_filepath = DUPLICATOR_PRO_WPROOTPATH . '.htaccess';

        $success = false;

        $zipArchive = new ZipArchive();

        if ($zipArchive->open($zip_filepath, ZIPARCHIVE::CREATE) === TRUE) {
            DUP_PRO_LOG::trace("Successfully opened zip $zip_filepath");

			if(file_exists($htaccess_filepath)) {
				DUP_PRO_Zip_U::addFileToZipArchive($zipArchive, $htaccess_filepath, DUPLICATOR_PRO_HTACCESS_ORIG_FILENAME, $is_compressed);
			}

            $temp_conf_ark_file_path = '';
			if(file_exists($wpconfig_filepath)) {
                $conf_ark_file_path = $this->getWPConfArkFilePath();
                $temp_conf_ark_file_path = $this->getTempWPConfArkFilePath();
                if (copy($wpconfig_filepath, $temp_conf_ark_file_path)) {
                    $this->cleanTempWPConfArkFilePath($temp_conf_ark_file_path);
                    DUP_PRO_Zip_U::addFileToZipArchive($zipArchive, $temp_conf_ark_file_path, $conf_ark_file_path, $is_compressed);
                } else {
                    DUP_PRO_Zip_U::addFileToZipArchive($zipArchive, $wpconfig_filepath, $conf_ark_file_path, $is_compressed);
                }
			}
            
            $embedded_scan_ark_file_path = $this->getEmbeddedScanFilePath();


            if (DUP_PRO_Zip_U::addFileToZipArchive($zipArchive, $scan_filepath, $embedded_scan_ark_file_path, $is_compressed)) {
                if (DUP_PRO_Zip_U::addFileToZipArchive($zipArchive, $file_list_filepath, $this->getEmbeddedScanFileList(), $is_compressed)) {
                    if (DUP_PRO_Zip_U::addFileToZipArchive($zipArchive, $dir_list_filepath, $this->getEmbeddedScanDirList(), $is_compressed)) {
                        if ($this->add_installer_files_using_zip_archive($zipArchive, $installer_filepath, $archive_config_filepath, $is_compressed)) {
                            DUP_PRO_Log::info("Installer files added to archive");
                            DUP_PRO_LOG::trace("Added to archive");

                            $success = true;
                        } else {
                            DUP_PRO_Log::error("Unable to add enhanced enhanced installer files to archive.", '', false);
                        }
                    } else{
                        DUP_PRO_Log::error("Unable to add dir list file to archive.", '', false);
                    }
                } else{
                    DUP_PRO_Log::error("Unable to add file list file to archive.", '', false);
                }
            } else {
                DUP_PRO_Log::error("Unable to add scan file to archive.", '', false);
            }

            if ($zipArchive->close() === false) {
                DUP_PRO_Log::error("Couldn't close archive when adding extra files.");
                $success = false;
            }

            if (!empty($temp_conf_ark_file_path)) {
                @unlink($temp_conf_ark_file_path);
            }

            DUP_PRO_LOG::trace('After ziparchive close when adding installer');
        }

        return $success;
    }

    private function add_extra_files_using_shellexec($zip_filepath, $installer_filepath, $scan_filepath, $file_list_filepath, $dir_list_filepath, $sql_filepath, $archive_config_filepath, $wpconfig_filepath, $is_compressed)
    {
        $success = false;
        $global  = DUP_PRO_Global_Entity::get_instance();

        $installer_source_directory      = DUPLICATOR_PRO_PLUGIN_PATH.'installer/';
        $installer_dpro_source_directory = "$installer_source_directory/dup-installer";
        $extras_directory                = DUP_PRO_U::safePath(DUPLICATOR_PRO_SSDIR_PATH_TMP).'/extras';
        $extras_installer_directory      = $extras_directory.'/dup-installer';
        $extras_lib_directory            = $extras_installer_directory.'/lib';

        $snaplib_source_directory        = DUPLICATOR_PRO_LIB_PATH.'/snaplib';
        $fileops_source_directory        = DUPLICATOR_PRO_LIB_PATH.'/fileops';
        $config_source_directory         = DUPLICATOR_PRO_LIB_PATH.'/config';
        
        $extras_snaplib_directory        = $extras_installer_directory.'/lib/snaplib';
        $extras_fileops_directory        = $extras_installer_directory.'/lib/fileops';
        $extras_config_directory         = $extras_installer_directory.'/lib/config';

        $installer_backup_filepath = "$extras_directory/".$global->get_installer_backup_filename();

        $package_hash                 = $this->Package->get_package_hash();
        $dest_sql_filepath            = "$extras_installer_directory/dup-database__{$package_hash}.sql";
        $dest_archive_config_filepath = "$extras_installer_directory/dup-archive__{$package_hash}.txt";
        $dest_scan_filepath           = "$extras_installer_directory/dup-scan__{$package_hash}.json";
        //$dest_sql_filepath            = "$extras_directory/database.sql";
        //$dest_archive_config_filepath = "$extras_installer_directory/archive.cfg";
        //$dest_scan_filepath           = "$extras_directory/scan.json";
       
        $dest_file_list_filepath      = "$extras_installer_directory/dup-scanned-files__{$package_hash}.txt";
        $dest_dir_list_filepath       = "$extras_installer_directory/dup-scanned-dirs__{$package_hash}.txt";

		$htaccess_filepath = DUPLICATOR_PRO_WPROOTPATH . '.htaccess';
		$dest_htaccess_orig_filepath  = "{$extras_directory}/" . DUPLICATOR_PRO_HTACCESS_ORIG_FILENAME;

		$dest_wpconfig_ark_filepath  = "{$extras_directory}/dup-wp-config-arc__{$package_hash}.txt";

        if (file_exists($extras_directory)) {
            if (DUP_PRO_IO::deleteTree($extras_directory) === false) {
                DUP_PRO_Log::error("Error deleting $extras_directory", '', false);
                return false;
            }
        }

        if (!@mkdir($extras_directory)) {
            DUP_PRO_Log::error("Error creating extras directory", "Couldn't create $extras_directory", false);
            return false;
        }

        if (!@mkdir($extras_installer_directory)) {
            DUP_PRO_Log::error("Error creating extras directory", "Couldn't create $extras_installer_directory", false);
            return false;
        }

        if (@copy($installer_filepath, $installer_backup_filepath) === false) {
            DUP_PRO_Log::error("Error copying $installer_filepath to $installer_backup_filepath", '', false);
            return false;
        }

        if (@copy($sql_filepath, $dest_sql_filepath) === false) {
            DUP_PRO_Log::error("Error copying $sql_filepath to $dest_sql_filepath", '', false);
            return false;
        }

        if (@copy($archive_config_filepath, $dest_archive_config_filepath) === false) {
            DUP_PRO_Log::error("Error copying $archive_config_filepath to $dest_archive_config_filepath", '', false);
            return false;
        }

        if (@copy($scan_filepath, $dest_scan_filepath) === false) {
            DUP_PRO_Log::error("Error copying $scan_filepath to $dest_scan_filepath", '', false);
            return false;
        }

        if (@copy($file_list_filepath, $dest_file_list_filepath) === false) {
            DUP_PRO_Log::error("Error copying $file_list_filepath to $dest_file_list_filepath", '', false);
            return false;
        }

        if (@copy($dir_list_filepath, $dest_dir_list_filepath) === false) {
            DUP_PRO_Log::error("Error copying $dir_list_filepath to $dest_dir_list_filepath", '', false);
            return false;
        }

		if(file_exists($htaccess_filepath)) {
			DUP_PRO_LOG::trace("{$htaccess_filepath} exists so copying to {$dest_htaccess_orig_filepath}");
			@copy($htaccess_filepath, $dest_htaccess_orig_filepath);
		}

		if(file_exists($wpconfig_filepath)) {
			DUP_PRO_LOG::trace("{$wpconfig_filepath} exists so copying to {$dest_wpconfig_ark_filepath}");
            @copy($wpconfig_filepath, $dest_wpconfig_ark_filepath);
            $this->cleanTempWPConfArkFilePath($dest_wpconfig_ark_filepath);
		}

        $one_stage_add = strtoupper($global->get_installer_extension()) == 'PHP';

        if ($one_stage_add) {

            if (!@mkdir($extras_snaplib_directory, 0755, true)) {
                DUP_PRO_Log::error("Error creating extras snaplib directory", "Couldn't create $extras_snaplib_directory", false);
                return false;
            }

            if (!@mkdir($extras_fileops_directory, 0755, true)) {
                DUP_PRO_Log::error("Error creating extras fileops directory", "Couldn't create $extras_fileops_directory", false);
                return false;
            }

            // If the installer has the PHP extension copy the installer files to add all extras in one shot since the server supports creation of PHP files
            if (DUP_PRO_IO::copyDir($installer_dpro_source_directory, $extras_installer_directory) === false) {
                DUP_PRO_Log::error("Error copying installer file directory to extras directory", "Couldn't copy $installer_dpro_source_directory to $extras_installer_directory", false);
                return false;
            }

            if (DUP_PRO_IO::copyDir($snaplib_source_directory, $extras_snaplib_directory) === false) {
                DUP_PRO_Log::error("Error copying installer snaplib directory to extras directory", "Couldn't copy $snaplib_source_directory to $extras_snaplib_directory", false);
                return false;
            }

            if (DUP_PRO_IO::copyDir($fileops_source_directory, $extras_fileops_directory) === false) {
                DUP_PRO_Log::error("Error copying installer fileops directory to extras directory", "Couldn't copy $fileops_source_directory to $extras_fileops_directory", false);
                return false;
            }

            if (DUP_PRO_IO::copyDir($config_source_directory, $extras_config_directory) === false) {
                DUP_PRO_Log::error("Error copying installer config directory to extras directory", "Couldn't copy $fileops_source_directory to $extras_fileops_directory", false);
                return false;
            }
        }

        //-- STAGE 1 ADD
        $compression_parameter = DUP_PRO_Shell_U::getCompressionParam($is_compressed);

        $command = 'cd '.escapeshellarg(DUP_PRO_U::safePath($extras_directory));
        $command .= ' && '.escapeshellcmd(DUP_PRO_Zip_U::getShellExecZipPath())." $compression_parameter".' -g -rq ';
        $command .= escapeshellarg($zip_filepath).' ./*';

        DUP_PRO_LOG::trace("Executing Shell Exec Zip Stage 1 to add extras: $command");

        $stderr = shell_exec($command);

        //-- STAGE 2 ADD - old code until we can figure out how to add the snaplib library within dup-installer/lib/snaplib
        if ($stderr == '') {
            if (!$one_stage_add) {
                // Since we didn't bundle the installer files in the earlier stage we have to zip things up right from the plugin source area
                $command = 'cd '.escapeshellarg($installer_source_directory);
                $command .= ' && '.escapeshellcmd(DUP_PRO_Zip_U::getShellExecZipPath())." $compression_parameter".' -g -rq ';
                $command .= escapeshellarg($zip_filepath).' dup-installer/*';

                DUP_PRO_LOG::trace("Executing Shell Exec Zip Stage 2 to add installer files: $command");
                $stderr = shell_exec($command);

                $command = 'cd '.escapeshellarg(DUPLICATOR_PRO_LIB_PATH);
                $command .= ' && '.escapeshellcmd(DUP_PRO_Zip_U::getShellExecZipPath())." $compression_parameter".' -g -rq ';
                $command .= escapeshellarg($zip_filepath).' snaplib/* fileops/*';

                DUP_PRO_LOG::trace("Executing Shell Exec Zip Stage 2 to add installer files: $command");
                $stderr = shell_exec($command);
            }
        }

  //rsr temp      DUP_PRO_IO::deleteTree($extras_directory);

        if ($stderr == '') {
            if (DUP_PRO_U::getExeFilepath('unzip') != NULL) {
                $installer_backup_filename = basename($installer_backup_filepath);

                // Verify the essential extras got in there
                $extra_count_string = "unzip -Z1 '$zip_filepath' | grep '$installer_backup_filename\|dup-installer/dup-scan__{$package_hash}.json\|dup-installer/dup-database__{$package_hash}.sql\|archive__{$package_hash}.txt' | wc -l";

                DUP_PRO_LOG::trace("Executing extra count string $extra_count_string");

                $extra_count = DUP_PRO_Shell_U::runAndGetResponse($extra_count_string, 1);

                if (is_numeric($extra_count)) {
                    // Accounting for the sql and installer back files
                    if ($extra_count >= 4) {
                        // Since there could be files with same name accept when there are m
                        DUP_PRO_LOG::trace("Core extra files confirmed to be in the archive");
                        $success = true;
                    } else {
                        DUP_PRO_Log::error("Tried to verify core extra files but one or more were missing. Count = $extra_count", '', false);
                    }
                } else {
                    DUP_PRO_LOG::trace("Executed extra count string of $extra_count_string");
                    DUP_PRO_Log::error("Error retrieving extra count in shell zip ".$extra_count, '', false);
                }
            } else {
                DUP_PRO_LOG::trace("unzip doesn't exist so not doing the extra file check");
                $success = true;
            }
        }

		if(file_exists($extras_directory)) {
			try
			{
				DupProSnapLibIOU::rrmdir($extras_directory);
			}
			catch(Exception $ex)
			{
				DUP_PRO_LOG::trace("Couldn't recursively delete {$extras_directory}");
			}
		}

        return $success;
    }

    // Add installer directory to the archive and the archive.txt
    private function add_installer_files_using_zip_archive(&$zip_archive, $installer_filepath, $archive_config_filepath, $is_compressed)
    {
        $success                   = false;
        /* @var $global DUP_PRO_Global_Entity */
        $global                    = DUP_PRO_Global_Entity::get_instance();
        $installer_backup_filename = $global->get_installer_backup_filename();

        DUP_PRO_LOG::trace('Adding enhanced installer files to archive using ZipArchive');

        //   if ($zip_archive->addFile($installer_filepath, $installer_backup_filename)) {
        if (DUP_PRO_Zip_U::addFileToZipArchive($zip_archive, $installer_filepath, $installer_backup_filename, $is_compressed)) {
            DUPLICATOR_PRO_PLUGIN_PATH.'installer/';

            $installer_directory = DUPLICATOR_PRO_PLUGIN_PATH.'installer/dup-installer';


            if (DUP_PRO_Zip_U::addDirWithZipArchive($zip_archive, $installer_directory, true, '', $is_compressed)) {
                $archive_config_local_name = $this->getArchiveTxtFilePath();

                // if ($zip_archive->addFile($archive_config_filepath, $archive_config_local_name)) {
                if (DUP_PRO_Zip_U::addFileToZipArchive($zip_archive, $archive_config_filepath, $archive_config_local_name, $is_compressed)) {

                    $snaplib_directory = DUPLICATOR_PRO_PLUGIN_PATH . 'lib/snaplib';
                    $fileops_directory = DUPLICATOR_PRO_PLUGIN_PATH . 'lib/fileops';
                    $config_directory = DUPLICATOR_PRO_PLUGIN_PATH . 'lib/config';

                    //DupArchiveEngine::addDirectoryToArchiveST($archive_filepath, $snaplib_directory, DUPLICATOR_PRO_PLUGIN_PATH, true, 'dup-installer/');
                    if (DUP_PRO_Zip_U::addDirWithZipArchive($zip_archive, $snaplib_directory, true, 'dup-installer/lib/', $is_compressed)
                        &&
                        DUP_PRO_Zip_U::addDirWithZipArchive($zip_archive, $fileops_directory, true, 'dup-installer/lib/', $is_compressed) 
                        &&
                        DUP_PRO_Zip_U::addDirWithZipArchive($zip_archive, $config_directory, true, 'dup-installer/lib/', $is_compressed)
                    ) {
                        $success = true;
                    } else {
                        DUP_PRO_Log::error("Error adding directory {$snaplib_directory} or {$fileops_directory} or {$config_directory} to zipArchive", '', false);
                    }
                } else {
                    DUP_PRO_Log::error("Error adding $archive_config_filepath to zipArchive", '', false);
                }
            } else {
                DUP_PRO_Log::error("Error adding directory $installer_directory to zipArchive", '', false);
            }
        } else {
            DUP_PRO_Log::error("Error adding backup installer file to zipArchive", '', false);
        }

        return $success;
    }

    /**
     * Get wp-config.php file path along with name in archive file
     */
    private function getWPConfArkFilePath()
    {
        $package_hash = $this->Package->get_package_hash();
        $conf_ark_file_path = 'dup-wp-config-arc__'.$package_hash.'.txt';
        return $conf_ark_file_path;
    }

    /**
     * Get temp wp-config.php file path along with name in temp folder
     */
    private function getTempWPConfArkFilePath()
    {
        $temp_conf_ark_file_path = DUP_PRO_U::safePath(DUPLICATOR_PRO_SSDIR_PATH_TMP).'/'.$this->Package->NameHash.'_wp-config.txt';
        return $temp_conf_ark_file_path;
    }

    /**
     * Clear out sensitive database connection information
     *
     * @param $temp_conf_ark_file_path Temp config file path
     */
    private static function cleanTempWPConfArkFilePath($temp_conf_ark_file_path) {
        if (function_exists('token_get_all')) {
            require_once(DUPLICATOR_PRO_PLUGIN_PATH . 'lib/config/class.wp.config.tranformer.php');
            $transformer = new WPConfigTransformer($temp_conf_ark_file_path);
            $constants = array('DB_NAME', 'DB_USER', 'DB_PASSWORD', 'DB_HOST');
            foreach ($constants as $constant) {
                if ($transformer->exists('constant', $constant)) {
                    $transformer->update('constant', $constant, '');
                }
            }
        }
    }

     private function getEmbeddedScanFileList() {
        $package_hash = $this->Package->get_package_hash();
        $embedded_filepath = 'dup-installer/dup-scanned-files__'.$package_hash.'.txt';
        return $embedded_filepath;
    }

     private function getEmbeddedScanDirList() {
        $package_hash = $this->Package->get_package_hash();
        $embedded_filepath = 'dup-installer/dup-scanned-dirs__'.$package_hash.'.txt';
        return $embedded_filepath;
    }


    /**
     * Get scan.json file path along with name in archive file
     */
    private function getEmbeddedScanFilePath() {
        $package_hash = $this->Package->get_package_hash();
        $embedded_scan_ark_file_path = 'dup-installer/dup-scan__'.$package_hash.'.json';
        return $embedded_scan_ark_file_path;
    }

    /**
     * Get archive.txt file path along with name in archive file
     */
    private function getArchiveTxtFilePath() {
        $package_hash = $this->Package->get_package_hash();
        $archive_txt_file_path = 'dup-installer/dup-archive__'.$package_hash.'.txt';
        return $archive_txt_file_path;
    }

    /**
     * Get scanned_files.txt file path along with name in archive file
     * 
     * @return string scanned_files.txt file path
     */
    private function getEmbeddedFileListFilePath() {
        $package_hash = $this->Package->get_package_hash();
        $embedded_file_list_file_path = 'dup-installer/dup-scanned-files__'.$package_hash.'.txt';
        return $embedded_file_list_file_path;
    }

    /**
     * Get scanned_dirs.txt file path along with name in archive file
     * 
     * @return string scanned_dirs.txt file path
     */
    private function getEmbeddedDirListFilePath() {
        $package_hash = $this->Package->get_package_hash();
        $embedded_dir_list_file_path = 'dup-installer/dup-scanned-dirs__'.$package_hash.'.txt';
        return $embedded_dir_list_file_path;
    }
 
}
